//
//  FJDSortedArrayController.h
//  FJDItemsInFolderWindow
//
//  Created by FUJIDANA on 06/08/17.
//  Copyright 2006 FUJIDANA. All rights reserved.
//

#import <Cocoa/Cocoa.h>


extern NSString *FJDSortedArrayControllerPboardType;


@interface FJDSortedArrayController : NSArrayController
{
	@private
		NSString	*_indexKeyPath;
		NSArray		*_defaultSortDescriptors;
}

#pragma mark Accessor methods
- (NSString *)indexKeyPath;
- (void)setIndexKeyPath:(NSString*)keyPath;

- (NSArray *)defaultSortDescriptors;
- (void)setDefaultSortDescriptors:(NSArray *)value;

- (BOOL)isSortedUsingDefaultDescriptors;

- (NSArray *)allObjects;

#pragma mark Auxiliary methods that helps drag and drop

- (void)reorderByMovingObjects:(NSArray *)movedObjects toArrangedObjectIndex:(unsigned int)index;

@end
